/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.model.ai.goals.jobs;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import java.util.List;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.ai.goals.Goal;
import technology.rocketjump.undermount.entities.model.ai.goals.exceptions.GoalException;
import technology.rocketjump.undermount.entities.model.ai.goals.jobs.WorkOnJobGoal;
import technology.rocketjump.undermount.entities.planning.JobAssignmentCallback;
import technology.rocketjump.undermount.jobs.model.Job;
import technology.rocketjump.undermount.jobs.model.JobState;

public class WaitForJobAssignmentGoal
extends Goal
implements JobAssignmentCallback {
    private final MessageDispatcher messageDispatcher;
    private WorkOnJobGoal parentGoal;
    private boolean callbackTriggered;

    public WaitForJobAssignmentGoal(Entity parentEntity, WorkOnJobGoal parentGoal, MessageDispatcher messageDispatcher) {
        super(parentEntity, parentGoal);
        this.messageDispatcher = messageDispatcher;
        this.parentGoal = parentGoal;
    }

    @Override
    public void update(float deltaTimeSeconds) throws GoalException {
    }

    @Override
    public boolean isComplete() {
        return this.callbackTriggered;
    }

    @Override
    public void jobCallback(List<Job> potentialJobs) {
        Job selectedJob = null;
        for (Job potentialJob : potentialJobs) {
            if (!potentialJob.getJobState().equals((Object)JobState.ASSIGNABLE) || potentialJob.getAssignedToEntityId() != null) continue;
            selectedJob = potentialJob;
            selectedJob.setAssignedToEntityId(this.parentEntity.getId());
            this.messageDispatcher.dispatchMessage(603, selectedJob);
            break;
        }
        this.callbackTriggered = true;
        this.parentGoal.setAssignedJob(selectedJob);
    }
}

